import $ from 'jquery';

var callback,
    self;

function scroll (data) {
  self = this;
  this.elems = data.elems;
  this.restore = data.restore;
  this.rwd = data.rwd;
  this.callback = data.callback;

  this.init();
}

scroll.prototype.init = function () {
  $(window).on('scroll', self.step);
};

scroll.prototype.destroy = function () {
  $(window).off('scroll', self.step);
};

scroll.prototype.get_offset_type = function () {
  
  let w = $(window).width(),
      rwd = this.rwd;

  for(var i in rwd) {
    if(i == 0 && w <= rwd[0]) return '0';
    else if(i == rwd.length - 1 && w >= rwd[i]) return rwd.length;
    else if(i > 0) {
      if(w >= rwd[i-1] && w <= rwd[i]) return i;
    }
  }
  return false;
}

scroll.prototype.step = function () {

  if(self.callback) self.callback();

  let es = self.elems,
      wh = $(window).height(),
      st = $(window).scrollTop(),
      ot = self.get_offset_type() || 0;

  for(var i in self.elems) {

    let el = $(es[i].name),
        t1 = el.offset().top,
        t2 = t1 + el.height() + 50,
        ofs = es[i].ofs[ot] || 0;
    
    if((wh + st + ofs - 50) > t1 && st < t2) el.addClass('in');
    else (self.restore && el.removeClass('in'))
  }
};

export default scroll;