import $ from 'jquery';

function SCROLL_COMPONENT (source) {
  
  var self = this;

  self.tag = source.tag || '';
  self.container = source.container;
  self.wrapImg = source.wrapImg;
  self.wrapScroll = source.wrapScroll;
  self.img1 = source.img1;
  self.img2 = source.img2;
  self.scrollBar = source.scrollBar;
  self.mask = source.mask;
  self.mask_0 = source.mask_0;
  self.mask_1 = source.mask_1;
  self.gap = source.gap || 0;
  self.posX = source.posX;
  self.task = [];
  self.demo = false;
  self.dragging = false;
  self.drag_first = source.drag_first || true;
  self.vertical_lock = false;
  self.offset = 1.1;

  self.tx = 0;
  self.px = self.gap;
  self.bx = 0;

  self.p = 0;

  self.minw = self.gap;
  self.maxw = 0;

  var size = {};

  if(source.ww == 0) {
    var size = global_resize();
  }
  else {
    size.ww = source.ww;
    size.wh = source.wh;
  }

  self.resize(size.ww, size.wh);
  self.init();
  
}

SCROLL_COMPONENT.prototype.init = function() {

  var self = this;
  
  var container = self.container;

  var events = device.mode == 'desktop' ? ['mousedown', 'mousemove', 'mouseup'] : ['touchstart', 'touchmove', 'touchend']

  $(container).on(events[0], function(e) {
    
    if(self.vertical_lock) e.preventDefault();
    self.dragging = true;
    if(self.drag_first) $(self).clearQueue().stop();
    self.bx = device.mode == 'desktop' ? e.clientX : e.originalEvent.touches[0].pageX;

    gtag('event', events[0], {
      'event_category': '拉霸互動',
      'event_label': self.tag
    });
    
    $(container).on(events[1], function(e) {
      if(!self.drag_first && self.demo) return;
      if(self.vertical_lock) e.preventDefault();
      self.drag(e);
    }); 
  });

  if(self.posX) {
    $(self.mask_0).css({width: self.maxw * (1 - self.posX)});
    $(self.mask_1).css({width: self.maxw * (1 - self.posX)});
    $(self.scrollBar).css({left: self.maxw * self.posX});
    self.px = self.maxw * self.posX;
  }
  else {
    $(self.mask_0).css({width: self.maxw - this.gap});
    $(self.mask_1).css({width: self.maxw - this.gap});
    $(self.scrollBar).css({left: this.gap});
  }

  $(container).on(events[2], function() {
    self.px = self.tx;
    self.dragging = false;
    $(container).off(events[1]);
  });
}

SCROLL_COMPONENT.prototype.add_task = function(task) {
  var self = this;
  self.task.push(task);
}

SCROLL_COMPONENT.prototype.demonstration = function(p1, p2, t1, t2, easing) {
  
  var self = this;

  if(p1 !== false) self.p = p1;

  $(self).delay(t2).animate({p: p2}, {
    duration: t1,
    easing: easing,
    step: function() {
      if(!self.drag_first || !self.dragging) self.move('auto', this.p);
    },
    start: function() {self.demo = true; },
    complete: function() {self.demo = false;}
  });
}

SCROLL_COMPONENT.prototype.resize = function(ww, wh) {
  
  var self = this;
  self.maxw = ww;
  
  $(self.container + ', ' + self.wrapImg + ', ' + self.wrapScroll + ', ' + self.img1 + ', ' + self.img2).css({width: ww, height: wh });
  
  if(self.px != this.gap) {
    $(self.mask_0, + ', ' + self.mask_1).css({width: self.maxw - self.px, height: wh });
  }
  else {
    $(self.mask_0, + ', ' + self.mask_1).css({width: self.maxw - this.gap, height: wh });
  }
}

SCROLL_COMPONENT.prototype.drag = function(e) {

  var self = this;

  if(!self.drag_first && self.demo) return;

  var x = device.mode == 'desktop' ? e.clientX : e.originalEvent.touches[0].pageX;
  
  self.tx = self.px - (self.bx - x) * self.offset;
  self.tx = self.tx <= self.minw ? self.minw : self.tx;
  self.tx = self.tx >= self.maxw ? self.maxw : self.tx;
  var p = self.tx / self.maxw;

  self.move('drag', p);
}

SCROLL_COMPONENT.prototype.move = function(mode, p) {

  var self = this;

  for(var i in self.task) {
    
    var t = self.task[i];
    
    if(p >= t.pos && t.do) {
      if(!t.infinite) t.do = false;
      if(t.callback) t.callback();
    }
  }

  var tx = p * self.maxw;

  $(self.scrollBar).css({left: tx});
  $(self.mask_0).css({width: self.maxw * (p)}); 
  $(self.mask_1).css({width: self.maxw * (1 - p)}); 

  if(mode == 'auto') self.px = tx;
}

function global_resize() {
  return {ww: $(window).width(), wh: $(window).height() };
}

export default {
  SCROLL_COMPONENT: SCROLL_COMPONENT  
}