var Animate = function() {

  var lastTime = 0;
  var vendors = ['webkit', 'moz'];
  for(var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
      window.requestAnimationFrame = window[vendors[x]+'RequestAnimationFrame'];
      window.cancelAnimationFrame =
      window[vendors[x]+'CancelAnimationFrame'] || window[vendors[x]+'CancelRequestAnimationFrame'];
  }

  if (!window.requestAnimationFrame) {
    window.requestAnimationFrame = function(callback, element) {
      var currTime = new Date().getTime();
      var timeToCall = Math.max(0, 16 - (currTime - lastTime));
      var id = window.setTimeout(function() {
          callback(currTime + timeToCall); 
        }, timeToCall);
      lastTime = currTime + timeToCall;
      return id;
    };
  }
      
  if(!window.cancelAnimationFrame) {
    window.cancelAnimationFrame = function(id) {clearTimeout(id); };
  }

  var self = this;
  this.play = false;
  this.then = 0;
  this.fpsInterval = 0;
  this.fps = 30;
  this.frameRate = '';
  this.startTime = 0;
  this.elapsed = 0;
  this.frameCount = 0;
  this.callback = '';
};

Animate.prototype.start = function(_fps, _callback){
  // if(this.play) return;
  this.fps = _fps;
  this.fpsInterval = 1000 / this.fps;
  this.callback = _callback;
  this.then = Date.now();
  this.startTime = this.then;
  this.play = true;
  this.tick();
};

Animate.prototype.stop = function() {
  this.play = false;
};

Animate.prototype.tick = function () {

  

  var self = this;

  if(!self.play) return;

  window.requestAnimationFrame(() => {self.tick(); });

  var now = Date.now();
  self.elapsed = now - self.then;

  if (self.elapsed > self.fpsInterval) {
    var sinceStart = now - self.startTime;
    self.then = now - (self.elapsed % self.fpsInterval);
    self.frameRate = Math.round(1000 / (sinceStart / ++ self.frameCount) * 100) / 100;
    self.callback();
  }
};

Animate.prototype.get_fps = function () {
  return self.frameRate;
};

export default {
  Animate: Animate
};