import $ from 'jquery';
import config from './config.js';

var api_post = function(api, data, callback) {

  if(config.log) console.log('call api: ', config.path.api + api);
        
  $.ajax({
    url: config.path.api + api,
    type: 'POST',
    dataType: 'JSON',
    data: data,
  })
  .done(function(res) {
    if(callback) callback(res);
  })
  .fail(function(res) {
    if(callback) callback(res);
  });
};

var api_get = function(api, callback) {

  if(config.log) console.log('call api: ', config.path.api + api);

  $.ajax({
    url: config.path.api + api,
    type: 'GET',
    dataType: 'JSON',
  })
  .done(function(res) {
    if(callback) callback(res);
  })
  .fail(function(res) {
    if(callback) callback(res);
  });
}

export default {
  get: api_get,
  post: api_post,
}