import Vue from 'vue';
import Router from 'vue-router';
import Meta from 'vue-meta';
import VueRouterTitle from 'vue-router-title';
import store from '../store/index.js';
import $ from 'jquery';
import Config from './../script/config.js';

/* components */
import Index from '@/components/index/Index';
import About from '@/components/about/Index';

import SignUp from './../components/signin/SignUp';
import Login from './../components/signin/Login';

import InvoiceIndex from './../components/invoice-lottery/Index';
import InvoiceSubmit from './../components/invoice-lottery/Submit';

import Winners from './../components/winners/Index';

const pret = '韋恩咖啡';
const pretcol = '韋恩咖啡::'
const mode = process.env.NODE_MODE == 'demo' ? 'history' : 'hash';
const base = process.env.NODE_MODE == 'demo' ? '/wincafe/brian/' : '';

const router = new Router({

  mode: mode,
  base: base,

  routes: [
    {
      path: '/',
      name: 'index',
      meta: {title: pretcol + '你的腦袋有動物', section: 'index', tag: '你的腦袋有動物'},
      component: Index
    }, {
      path: '/policy',
      name: 'policy',
      meta: {title: pretcol + '活動辦法', section: 'policy', tag: '活動辦法'},
      component: Index
    }, {
      path: '/about',
      name: 'about',
      meta: {title: pretcol + '關於韋恩', section: 'about', tag: '關於韋恩'},
      component: About
    }, {
      path: '/invoice-lottery/',
      name: 'invoice-lottery',
      component: InvoiceIndex,
      children: [
        {
          path: '/invoice-lottery/sign-up',
          name: 'sign-up',
          meta: {title: pretcol + '登錄發票抽大獎', section: 'invoice-signup', tag: '註冊'},
          component: SignUp,
        }, {
          path: '/invoice-lottery/login',
          name: 'login',
          meta: {title: pretcol + '登錄發票抽大獎', section: 'invoice-login', tag: '登入'},
          component: Login,
        }, {
          path: '/invoice-lottery/submit',
          name: 'invoice-submit',
          meta: {title: pretcol + '登錄發票抽大獎', section: 'invoice-submit', tag: '發票登錄'},
          component: InvoiceSubmit
        }
      ]
    }, {
      path: '/winners',
      name: 'winners',
      meta: {title: pretcol + '得獎名單', section: 'winners', tag: '得獎名單'},
      component: Winners
    }, {
      path: '*',
      name: 'index',
      meta: {title: pretcol + '首頁', section: 'index', tag: '蕭青陽特製罐'},
      component: Index
    }
  ],

  scrollBehavior (to, from, savedPosition) {
    return new Promise((resolve, reject) => {
      setTimeout(() => {
        if(to.name == 'index' && to.hash != '') return;
        if((from.name == 'login' && to.name == 'sign-up') || (from.name == 'sign-up' && to.name == 'login')) return;
        resolve({ x: 0, y: 0 });
      }, 300);
    });
  }
});

Vue.use(Router);
Vue.use(VueRouterTitle, {router});

router.beforeEach((to, from, next) => {  

  setTimeout(() => {

    var title = to.meta.tag,
        name = to.name,
        url = window.location.href;

    if(Config.tracking) gtag('config', 'UA-122809543-1', {page_title: title, page_location: url, page_path: name });
    
    store.commit('page', to.meta.section); 
  }, 200);

  next();
});

export default router;