import Vue from 'vue';
import Vuex from 'vuex';

Vue.use(Vuex);

const store = new Vuex.Store({


  state: {
    device: {mode: ''},

    loading: false,

    login: false,

    transitionValue: 0,

    header: 'header-close',
    
    page: '',

    policy: 'policy-hiden',
    
    index: {
      expert: 0,
      section1: 'expand',
      section3: 'open',
    },

    invoiceTime: '',

    rule: 'rule-hidden'
  },

  mutations: {
    device (state, val) {state.device = val; },
    login (state, val) {state.login = val; },
    header (state, val) {state.header = val; },
    loading (state, val) {state.loading = val; },
    policy (state, val) {state.policy = val; },
    transitionValue (state, val) {state.transitionValue = val; },
    page (state, val) {state.page = val; },
    invoiceTime (state, val) { state.invoiceTime = val; },
    index (state, val) {
      switch(val.key) {
        case 'expert': state.index.expert = val.content; break;
        case 'section1': state.index.section1 = val.content; break;
        case 'section3': state.index.section3 = val.content; break;
      }
    },
    rule (state, val) {state.rule = val; },
  },

  getters: {
    device (state) {return state.device; },
    mode (state) {return state.device.mode; },
    login (state) {return state.login; },
    header (state) {return state.header; },
    loading (state) {return state.loading; },
    policy (state) {return state.policy; },
    transitionValue (state) {return state.transitionValue; },
    page (state) {return state.page; },
    invoiceTime (state) {return state.invoiceTime; },
    index (state) {return state.index; },
    rule (state) {return state.rule; }
  },

  actions: {

  }
})



export default store;