import $ from 'jquery';

function SCROLL_COMPONENT (source) {
  
  var self = this;

  self.container = source.container;
  self.wrapImg = source.wrapImg;
  self.wrapScroll = source.wrapScroll;
  self.img1 = source.img1;
  self.img2 = source.img2;
  self.scrollBar = source.scrollBar;
  self.mask = source.mask;
  self.gap = 45;

  self.tx = 0;
  self.px = self.gap;
  self.bx = 0;

  self.minw = self.gap;
  self.maxw = 0;

  var size = {};

  if(source.ww == 0) {
    var size = global_resize();
  }
  else {
    size.ww = source.ww;
    size.wh = source.wh;
  }

  self.resize(size.ww, size.wh);
  self.init();
  
}

SCROLL_COMPONENT.prototype.init = function() {

  var self = this;
  
  var container = self.container;

  var events = device.mode == 'desktop' ? ['mousedown', 'mousemove', 'mouseup'] : ['touchstart', 'touchmove', 'touchend']

  $(container).on(events[0], function(e) {
    e.preventDefault();
    self.bx = device.mode == 'desktop' ? e.clientX : e.originalEvent.touches[0].pageX;
    $(container).on(events[1], function(e) {
      e.preventDefault();
      self.drop(e);
    }); 
  });

  $(self.mask).css({width: self.maxw - 45});

  $(container).on(events[2], function() {
    self.px = self.tx;
    $(container).off(events[1]);
  });
}

SCROLL_COMPONENT.prototype.resize = function(ww, wh) {
  var self = this;
  self.maxw = ww;
  $(self.container + ', ' + self.wrapImg + ', ' + self.wrapScroll + ', ' + self.img1 + ', ' + self.img2 + ', ' + self.mask).css({width: ww, height: wh });
}

SCROLL_COMPONENT.prototype.drop = function(e) {

  var self = this;

  var x = device.mode == 'desktop' ? e.clientX : e.originalEvent.touches[0].pageX;
  
  self.tx = self.px - (self.bx - x) * 2;
  self.tx = self.tx <= self.minw ? self.minw : self.tx;
  self.tx = self.tx >= self.maxw ? self.maxw : self.tx;

  var p = 1 - self.tx / self.maxw;
  
  $(self.scrollBar).css({left: self.tx});
  $(self.mask).css({width: self.maxw * p});

}

function global_resize() {
  return {ww: $(window).width(), wh: $(window).height() };
}

export default {
  SCROLL_COMPONENT: SCROLL_COMPONENT  
}