import $ from 'jquery';
import 'jquery.easing';

/*
 * 鎖定 input 類型
 */
const input_lock = {
  number: function (val, callback) {
    var self = this;
    var pnumber = val,
      regex = /^[0-9-#]+$/,
      str = '';
    if (pnumber == '') return;
    if (!regex.test(pnumber)) {
      alert('此欄位限輸入數字。');
      for (var i in pnumber) {
        if (regex.test(pnumber[i])) str += pnumber[i];
      }
      setTimeout(function() {
        callback(str);
      }, 0);
      
    }
  },
};


/*
 * 檢查中文
*/
const type_zh = function(name) {
  var regExp = /^[\u4e00-\u9fa5\s]+$/;
  if(name.match(regExp) && name != ' ' && name != '') return true;
  else return false;  
}

const checkPersonalID = function(id) {
    var id = id.toUpperCase();
    var strTab = "ABCDEFGHJKLMNPQRSTUVWXYZIO";
    var A1 = new Array(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3);
    var A2 = new Array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 0, 1, 3, 4, 5);
    var Mx = new Array(9, 8, 7, 6, 5, 4, 3, 2, 1, 1);
    if (!id.match(/^[a-z][12][\d]{8}$/i)) return false;
    var i = strTab.indexOf(id.charAt(0));
    if (i == -1) return false;
    var sum = A1[i] + A2[i] * 9;
    for (i = 1; i < 10; i++) {
        var v = parseInt(id.charAt(i));
        if (isNaN(v)) return false;
        sum = sum + v * Mx[i];
    }
    if (sum % 10 != 0) return false;
    return true;
}

const mobile_phone = function(phone) {
    var regExp_1 = "^[09]{2}[0-9]{2}[0-9]{6}$",
        regExp_2 = "^[09]{2}[0-9]{2}-[0-9]{6}$",
        regExp_3 = "^[09]{2}[0-9]{2}-[0-9]{3}-[0-9]{3}$";

    if (phone.match(regExp_1) || phone.match(regExp_2) || phone.match(regExp_3)) return true;
    else return false;
};


/*
 * 解析 event_time [ 2018-02-1 00:00:00 ]
 */
const parseTime = function (s) {
  var dateTime = s.split(' ');
  var dateBits = dateTime[0].split('-');
  var timeBits = dateTime[1].split(':');
  return new Date(dateBits[0], parseInt(dateBits[1]) - 1, dateBits[2], timeBits[0], timeBits[1], timeBits[2]).valueOf();
};

const check_empty = function(val) {
  if (!val || val == '' || val === undefined || val == NaN) return false;
  else return true;
}

const ValidEmail = function(emailtoCheck) {
    var regExp = /^[^@^\s]+@[^\.@^\s]+(\.[^\.@^\s]+)+$/;
    if (emailtoCheck.match(regExp)) return true;
    else return false;
}

const submit_check = function (data) {

  var prefix = '下列資訊尚未填寫或格式有誤\n---------------------\n';
  var lack = '';
  
  for (var i in data) {
    switch (i) {
      
      case 'ev_na': 
        if(!check_empty(data[i]) || !type_zh(data[i]) || data[i].length < 2) lack += '姓名, '; 
        break;

      case 'ev_em': 
        if(!check_empty(data[i]) || !ValidEmail(data[i])) lack += '電子信箱, '; 
        break;

      case 'ev_id':
        if(!check_empty(data[i]) || !checkPersonalID(data[i])) lack += '身分證字號, ';
        break;
      
      case 'ev_mp': 
        if(!check_empty(data[i]) || !mobile_phone(data[i])) lack += '電話號碼, '; 
        break;
      
      case 'ev_yr':
          if(!check_empty(data[i]) || data[i] == '年齡') lack += '請選擇年齡, '; 
        break;
      
      case 'ev_a1':
        if(!check_empty(data[i]) || data[i] == '選擇縣市') lack += '請選擇縣市, ';
        break;

      case 'ev_a2':
        if(!check_empty(data[i]) || data[i] == '選擇區域') lack += '請選擇區域, ';
        break;

      case 'ev_a3':
          if(!check_empty(data[i])) lack += '地址, ';
          break;
      
      case 'cc': 
        if(!check_empty(data[i])) lack += '驗證碼, '; 
        break;
    }
  }

  if (lack !== '') {
    lack = lack.substring(0, lack.length - 2);
    alert(prefix + lack);
    return false;
  }
  else return true;
};

var Hash = {
  
  set: function(v) {var hash = window.location.href.split('#'), modify = false; tmp = ''; if (hash.length < 2) {modify = true; tmp = '#' + v.key + '=' + v.value; } else {var p = hash[1].split('&'); for(var i in p) {var h = p[i].split('='), k = h[0], c = h[1]; var tmp = '', nh = v.key + '=' + v.value; if(k == v.key) {modify = true; tmp = hash[1].replace(p[i], nh); break; } } if(!modify) tmp = hash[1] += ('&' + nh); } window.location.hash = tmp; },
  get: function(v) {var hash = window.location.href.split('#'); if (hash.length < 2) {return false; } else {var p = hash[1].split('&'); for (var i in p) {var key = p[i].split('=')[0]; if (v == key) {return p[i].split('=')[1]; }; } return false; } },
  remove: function(v) {var hash = window.location.href.split('#'); if (hash.length < 2) {return false; } else {var p = hash[1].split('&'); var op = ""; v = v.split(' ').join('').split(','); var index = 0; for (var i in p) {var key = p[i].split('=')[0]; var c = 0; for (var j in v) {if (v[j] == key) c++; } if (c == 0) {if (index > 0) op += "&"; index++; op += p[i]; } } return op; } }, 
  print: function() {var hash = window.location.href.split('#'); if (hash.length < 2) {return false; } else {return hash[1]; } }, 
  root: function() {var hash = window.location.href.split('/'); var op = ""; for (var i in hash) {if (i < hash.length - 1) op += hash[i] + "/"; } return op.split('?')[0]; } };

var fixed_num = function(num, index) {
  
  var str = String(num),
      len = str.length;

  for(var i=0; i<(index-len); i++) {
    str = '0' + str;
  }
  return str;
}

function scrollTo(top, time) {
  var st = $(window).scrollTop();
      
  $({st: st}).animate({
    st: top
  }, {
    duration: time,
    easing: 'easeInOutQuart',
    step: function() {$(window).scrollTop(this.st); },
    complete: function() {$(window).scrollTop(top); }
  });
};

export default {
  input_lock: input_lock,
  submit_check: submit_check,
  parseTime: parseTime,
  fixed_num: fixed_num,
  hash: Hash,
  scrollTo: scrollTo
};